/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.Trace;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class PropertiesTool {
    private static final String TRACE_MASKT = "XFRMPRPT";
    private static final String TRACE_MASKF = "XFRMPRPF";
    private static final String TRACE_MASKD = "XFRMPRPD";

    public static Map readCustomProperties(String fileName) {
        Trace.trace(TRACE_MASKT, "-> PropertiesTool.readCustomProperties(" + fileName + ")");
        Properties p = new Properties();
        HashMap returnMap = new HashMap();
        try {
            p.load(new FileInputStream(fileName));
            Iterator<Object> i = p.keySet().iterator();
            while (i.hasNext()) {
                String obj;
                String key = (String)i.next();
                String value = (String)p.get(key);
                if (value.endsWith("!")) {
                    value = value.substring(0, value.length() - 1);
                    try {
                        obj = Class.forName(value).newInstance();
                    }
                    catch (ClassNotFoundException cnfe) {
                        Trace.trace(TRACE_MASKF, "PropertiesTool.readCustomProperties(): Class not found for instantiation: " + cnfe.getMessage());
                        obj = null;
                    }
                } else {
                    obj = value;
                }
                if (obj == null) continue;
                try {
                    returnMap.put(Class.forName(key), obj);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "PropertiesTool.readCustomProperties(): Error with key: " + key + ":" + e.toString());
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "PropertiesTool.readCustomProperties(): Error reading file: " + fileName + "\n" + e.getMessage());
            return null;
        }
        Trace.trace(TRACE_MASKT, "<- PropertiesTool.readCustomProperties()");
        return returnMap;
    }
}

